	function [Gbp, Zbp, Pbp] = CA_POLES_BP_Z(wc1T, wc2T, ws1T, ws2T, Amax, Amin)
 
	%	Computes the poles and zeros for a bandpass filter of Cauer type.
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar, 2010-10-08
	% 	Modified by: 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	% Requirements for the analog prototype lowpass filter
	T = 1;
	wac1 = (2/T)*tan(wc1T/2);	wac2 = (2/T)*tan(wc2T/2);
	was1 = (2/T)*tan(ws1T/2);	was2 = (2/T)*tan(ws2T/2);

	was2 = wac1*wac2/was1;		% We select
	
	% Band edges for the  analog filter
	Omegac = wac2 - wac1;
	Omegas = was2 - was1;
	
	N = ceil(CA_ORDER_S(Omegac, Omegas, Amax, Amin)); % We must select an integer order
 
	% Design of the analog prototype lowpass filter (Cauer)
	[Ga, Za, R_ZEROS, Pa, wsnew] = CA_POLES_S(Omegac, Omegas, Amax, Amin, N);
	
	% Transform the analog filter into a lowpass digital filter
	[G, Z, P] = PZ_2_PZ_Z(Ga, Za, Pa, T);
	
	% Transform the lowpass filter into a digital bandpass filter
	[Gbp, Zbp, Pbp] = PZ_2_BP_Z(G, Z, P, wc1T, wc2T, Omegac*T);
